﻿using UnityEditor;
using static PK.HexVariablesModel;

namespace PK
{
    [CustomEditor(typeof(HexPlayer))]
    public class HexPlayerEditor : Editor
    {
        private SerializedProperty _variables;

        private void OnEnable()
        {
            _variables = serializedObject.FindProperty("_variables");
        }

        public override void OnInspectorGUI()
        {
            int size = _variables.arraySize;
            EditorGUI.BeginChangeCheck();
            EditorGUILayout.PropertyField(_variables);
            if (size < _variables.arraySize)
            {
                _variables.GetArrayElementAtIndex(_variables.arraySize - 1).boxedValue = new Variable(HexHelper.GenerateUID(), "Variable", VariableType.Bool);
            }
            if (EditorGUI.EndChangeCheck())
            {
                serializedObject.ApplyModifiedProperties();
            }
        }
    }
}
