using System.Collections.Generic;
using UnityEngine;
using UnityEditor;

namespace PK
{
    class RuntimeVariablesListWindow : EditorWindow
    {
        private Vector2 _scrollPosition;

        [MenuItem("PK/All Runtime Variables")]
        public static void ShowWindow()
        {
            var window = EditorWindow.GetWindow(typeof(RuntimeVariablesListWindow));
            window.titleContent = new GUIContent("Runtime Variable List");
        }

        public bool RequiresConstantRepaint() => true;

        private void OnGUI()
        {
            if (null == Strategic.StrategicGameMediator.Instance)
            {
                EditorGUILayout.LabelField("Only work when game is running!", EditorStyles.boldLabel);
                return;
            }

            _scrollPosition = EditorGUILayout.BeginScrollView(_scrollPosition);
            GUILayout.BeginHorizontal();
            EditorGUILayout.LabelField("Name", EditorStyles.boldLabel);
            EditorGUILayout.LabelField("Type", EditorStyles.boldLabel);
            EditorGUILayout.LabelField("Value", EditorStyles.boldLabel);
            GUILayout.EndHorizontal();

            Dictionary<ulong, HexVariablesModel.Variable> variables = Strategic.StrategicGameMediator.Instance.Variables.VariablesDict;

            foreach (KeyValuePair<ulong, HexVariablesModel.Variable> pair in variables)
            {
                GUILayout.BeginHorizontal();
                EditorGUILayout.LabelField(pair.Value.Name);
                if (pair.Value.Type == VariableType.Bool)
                {
                    EditorGUILayout.LabelField("Bool");
                    EditorGUILayout.LabelField(pair.Value.BoolValue.ToString());
                }
                else
                {
                    EditorGUILayout.LabelField("Int");
                    EditorGUILayout.LabelField(pair.Value.IntValue.ToString());
                }
                GUILayout.EndHorizontal();
            }

            EditorGUILayout.EndScrollView();
        }
    }
}
