﻿using UnityEngine;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Creatures/Creature")]
    public class HexCreature : HexUniqueScriptableObject
    {
        [SerializeField] private Sprite _icon;
        [SerializeField] private Sprite _roundIcon;
        [SerializeField] private HexCreatureView _strategicMapPrefab;
        [SerializeField] private HexCreatureSquadView _tacticalMapPrefab;
        [SerializeField] private HexCreatureSquadUnitView _tacticalMapUnitPrefab;

        [Space]
        [SerializeField] private HexBanerView _selfTacticalBanerPrefab;
        [SerializeField] private HexBanerView _enemyTacticalBanerPrefab;

        [Space]
        [SerializeField] private float _health = 1.0f;
        [SerializeField] private float _damage = 1.0f;
        [SerializeField] private int _visionRange = 5;

        [Space]
        [SerializeField] private int _minSoldiersPerHex = 5;
        [SerializeField] private int _maxSoldiersPerHex = 5;
        [SerializeField] private int _soldiersPerUnit = 15;
        [SerializeField] private int _stepsPerTurn = 5;

        [Space]
        [SerializeField] private AudioPreset _selectSfx;
        [SerializeField] private AudioPreset _moveSfx;
        [SerializeField] private AudioPreset _meleeAttackSfx;
        [SerializeField] private AudioPreset _hitSfx;
        [SerializeField] private AudioPreset _surrenderSfx;
        [SerializeField] private AudioPreset _deathSfx;

        public Sprite Icon { get { return _icon; } }
        public Sprite RoundIcon { get { return _roundIcon; } }
        public Sprite AnySprite
        {
            get
            {
                if (_strategicMapPrefab != null && _strategicMapPrefab.TryGetComponent(out SpriteRenderer spriteRenderer))
                {
                    return spriteRenderer.sprite;
                }

                if (_tacticalMapPrefab != null && _tacticalMapPrefab.TryGetComponent(out spriteRenderer))
                {
                    return spriteRenderer.sprite;
                }

                return null;
            }
        }

        public HexEntityView GetView(Transform parent, bool isStrategic)
        {
            HexEntityView view = (HexEntityView)Instantiate(isStrategic ? _strategicMapPrefab : _tacticalMapPrefab);
            view.transform.SetParent(parent, false);
            return view;
        }

        public HexCreatureView StrategicMapPrefab { get { return _strategicMapPrefab; } }
        public HexCreatureSquadView TacticalMapPrefab { get { return _tacticalMapPrefab; } }
        public HexCreatureSquadUnitView TacticalMapUnitPrefab { get { return _tacticalMapUnitPrefab; } }

        public HexBanerView SelfTacticalBanerPrefab { get { return _selfTacticalBanerPrefab; } }
        public HexBanerView EnemyTacticalBanerPrefab { get { return _enemyTacticalBanerPrefab; } }

        public float Health { get { return _health; } }
        public float Damage { get { return _damage; } }
        public int VisionRange { get { return _visionRange; } }

        public int MinSoldiersPerHex { get { return _minSoldiersPerHex; } }
        public int MaxSoldiersPerHex { get { return _maxSoldiersPerHex; } }
        public int SoldiersPerUnit { get { return _soldiersPerUnit; } }
        public int StepsPerTurn { get { return _stepsPerTurn; } }

        public AudioPreset SelectSfx { get { return _selectSfx; } }
        public AudioPreset MoveSfx { get { return _moveSfx; } }
        public AudioPreset MeleeAttackSfx { get { return _meleeAttackSfx; } }
        public AudioPreset HitSfx { get { return _hitSfx; } }
        public AudioPreset SurrenderSfx { get { return _surrenderSfx; } }
        public AudioPreset DeathSfx { get { return _deathSfx; } }
    }
}
