﻿using UnityEngine;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Terrain")]
    public class HexTerrain : ScriptableObject
    {
        [SerializeField] private HexTile[] _tiles;
        [SerializeField] private int _priority = 0;
        [SerializeField] private byte _strategicMovementCost = 5;
        [SerializeField] private byte _tacticalMovementCost = 5;
        [SerializeField] private Color _selectionTint = new Color(1.0f, 1.0f, 1.0f, 0.25f);

        public HexTile[] Tiles { get { return _tiles; } }
        public int Priority { get { return _priority; } }
        public byte StrategicMovementCost { get { return _strategicMovementCost; } }
        public byte TacticalMovementCost { get { return _tacticalMovementCost; } }
        public Color SelectionTint { get { return _selectionTint; } }

        private void OnEnable()
        {
            foreach (HexTile tile in _tiles)
            {
                tile.Terrain = this;
            }
        }
    }
}
