using UnityEngine;

namespace PK
{
    [CreateAssetMenu(menuName = "Hex/Weather")]
    public class HexWeather : ScriptableObject
    {
        public enum Severity
        {
            None,
            Low,
            Medium,
            High
        }

        [System.Serializable]
        public class SeveritySettings
        {
            public float minLifetime;
            public float maxLifetime;
            public float minSpeed;
            public float maxSpeed;
            public float minSize;
            public float maxSize;
            public Color startColor;
            public float emissionRatePerHex;
            public bool noiseEnabled;
            public float noiseStrength;
            public float noiseFrequency;
            public float noiseScrollSpeed;
            public ParticleSystemNoiseQuality noiseQuality;
            public Vector3 baseWindDirection;
            public float windFrequency;
            public float windTurbulence;
            public float windIncreaseIntervalMin;
            public float windIncreaseIntervalMax;
            public float windIncreaseStrength;
            public float zVelocityNoiseAmplitude;
            public float zVelocityNoiseFrequency;
            public float lodEmissionRateMultiplier;
            public float lodStartSpeedMultiplier;
            public float windGustAffectedPercentage; // Percentage of particles affected by wind gusts
            public float windGustFrequencyMin;
            public float windGustFrequencyMax;
            public float windGustStrengthMultiplier;
            public float windGustDuration;
        }

        public string weatherName;
        public Material particleMaterial;
        public Sprite particleSprite;
        public string sortingLayerName;
        public int sortingOrder;
        public float pixelGridSize;
        public LayerMask windObstructionMask;
        public float nearDistance;
        public float farDistance;
        public SeveritySettings lowSeveritySettings;
        public SeveritySettings mediumSeveritySettings;
        public SeveritySettings highSeveritySettings;

        public SeveritySettings GetSettingsForSeverity(Severity severity)
        {
            switch (severity)
            {
                case Severity.Low:
                    return lowSeveritySettings;
                case Severity.Medium:
                    return mediumSeveritySettings;
                case Severity.High:
                    return highSeveritySettings;
                default:
                    return null;
            }
        }
    }
}