﻿
namespace PK
{
    public interface IActionContext
    {
        public Player Player { get; }
        public object Executor { get; }
        public object Interactor { get; }
        public HexMapModel Map { get; }
        public Savefile.MapData MapData { get; }
        public Savefile Savefile { get; }
        public ActionGraph Graph { get; }
        public IEventManager EventManager { get; }
        public IControllerLocker Locker { get; }
    }

    public class ActionContext : IActionContext
    {
        private Player _player;
        private object _executor;
        private object _interactor;
        private Savefile.MapData _mapData;
        private Savefile _savefile;
        private ActionGraph _graph;
        private IEventManager _eventManager;
        private IControllerLocker _locker;
        
        Player IActionContext.Player => _player;
        object IActionContext.Executor => _executor;
        object IActionContext.Interactor => _interactor;
        HexMapModel IActionContext.Map => _mapData.Map;
        Savefile.MapData IActionContext.MapData => _mapData;
        Savefile IActionContext.Savefile => _savefile;
        ActionGraph IActionContext.Graph => _graph;
        IEventManager IActionContext.EventManager => _eventManager;
        IControllerLocker IActionContext.Locker { get { return _locker; } }

        public ActionContext(Player player, Savefile.MapData mapData, Savefile savefile, object executor, object interactor, ActionGraph graph, IEventManager eventManager, IControllerLocker locker)
        {
            _player = player;
            _executor = executor;
            _interactor = interactor;
            _mapData = mapData;
            _savefile = savefile;
            _graph = graph;
            _eventManager = eventManager;
            _locker = locker;
        }
    }
}
