﻿using UnityEngine;

namespace PK
{
    [System.Serializable]
    public class BattleData
    {
        [SerializeField] private HexMap _map;
        [SerializeField] private ulong _heroId;
        [SerializeField] private ulong _enemyId;
        [SerializeField] private HexCreatureSquadModel[] _enemySquads;
        [SerializeField] private Player _beginer = Player.Red;
        [SerializeField] private Player _winner = Player.Unknown;
        [SerializeField] private bool _canRetry;

        public HexMap Map { get { return _map; } }
        public ulong HeroId { get { return _heroId; } }
        public ulong EnemyId { get { return _enemyId; } }
        public HexCreatureSquadModel[] EnemySquads { get { return _enemySquads; } }
        public Player Beginer { get { return _beginer; } }
        public Player Winner { get { return _winner; } set { _winner = value; } }
        public bool CanRetry { get { return _canRetry; } }

        public BattleData(HexMap map, ulong heroId, ulong enemyId, HexCreatureSquadModel[] enemySquads, bool canRetry, Player beginer = Player.Red)
        {
            _map = map;
            _heroId = heroId;
            _enemyId = enemyId;
            _enemySquads = enemySquads;
            _beginer = beginer;
            _canRetry = canRetry;
        }
    }
}
