﻿using System.Collections.Generic;

namespace PK
{
    public interface IControllerLocker
    {
        void Lock(string id);
        void Unlock(string id);

        bool IsLock { get; }
    }

    public class ControllerLocker : IControllerLocker
    {
        private HashSet<string> _locks = new HashSet<string>();

        bool IControllerLocker.IsLock => _locks.Count > 0;

        void IControllerLocker.Lock(string id)
        {
            _locks.Add(id);
        }

        void IControllerLocker.Unlock(string id)
        {
            _locks.Remove(id);
        }
    }
}
