﻿using System;
using System.Collections.Generic;
using UnityEngine;

namespace PK
{
    public interface IEventManager
    {
        T Get<T>() where T : class;
    }

    public class EventManager : IEventManager
    {
        private Dictionary<Type, object> _eventManagers = new();

        public void Register<TRead, TWrite>(TRead eventManager) where TRead : class where TWrite : class
        {
            Type idRead = typeof(TRead);
            Type idWrite = typeof(TWrite);

            TWrite readObj = eventManager as TWrite;

            if (_eventManagers.ContainsKey(idRead))
            {
                Debug.LogError($"EventManager.PushManager: already contains {idRead}");
            }

            if (_eventManagers.ContainsKey(idWrite))
            {
                Debug.LogError($"EventManager.PushManager: already contains {idWrite}");
            }

            if (readObj == null)
            {
                Debug.LogError("EventManager.Register: Error convert to read");
            }
            else
            {
                _eventManagers[idRead] = readObj;
                _eventManagers[idWrite] = eventManager;
            }
        }

        T IEventManager.Get<T>()
        {
            Type id = typeof(T);

            T result = null;
            if (_eventManagers.TryGetValue(id, out object r))
            {
                result = r as T;
            }

            if (result == null)
            {
                Debug.LogError($"EventManager.Get<T>: not contains {id}");
            }

            return result;
        }
    }
}
