﻿
namespace PK
{
    public delegate void OnMessageEvent(IDialogMessageForView messageForView, Player player);
    public delegate void OnDialogEvent(IDialogChoicesForView dialogChoicesForView, Player player);

    public interface IInteractionEvents
    {
        public event OnMessageEvent OnMessage;
        public event OnDialogEvent OnDialog;
    }

    public class InteractionEvents : IInteractionEvents
    {
        public event OnMessageEvent OnMessage;
        public event OnDialogEvent OnDialog;

        public void CallOnMessage(IDialogMessageForView messageForView, Player player)
        {
            OnMessage?.Invoke(messageForView, player);
        }

        public void CallOnDialog(IDialogChoicesForView dialogChoicesForView, Player player)
        {
            OnDialog?.Invoke(dialogChoicesForView, player);
        }
    }
}
