﻿using UnityEngine;

namespace PK.Strategic
{
    public partial class GameController
    {
        private class RevealFogOfWarCommand : Command
        {
            private Vector2Int _center;
            private int _radius;
            private Player _player;

            public RevealFogOfWarCommand(Vector2Int center, int radius, Player player)
            {
                _center = center;
                _radius = radius;
                _player = player;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                // TODO per player fog of war
                if (_player != Player.Red)
                {
                    return CommandResult.Complete;
                }
                Vector2Int axialCenter = HexHelper.OddToAxial(_center);
                Savefile.MapData mapData = context.MapData;
                for (int i = 0; i < mapData.Map.Size.x; i++)
                {
                    for (int j = 0; j < mapData.Map.Size.y; j++)
                    {
                        Vector2Int position = new Vector2Int(i, j);
                        if (HexHelper.AxialDistance(axialCenter, HexHelper.OddToAxial(position)) <= _radius)
                        {
                            mapData.RevealFogOfWar(position);
                        }
                    }
                }
                context.EventManager.Get<StrategicEvents>().CallOnUpdateFogOfWar(mapData.FogOfWarMask, mapData.Map.Size);
                return CommandResult.Complete;
            }
        }
    }
}
