﻿
namespace PK.Strategic
{
    public partial class GameController
    {
        private class StartGameCommand : Command
        {
            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                foreach (HexHeroModel hero in context.MapData.Map.GetEnumerable<HexHeroModel>())
                {
                    PushSubCommand(new RevealFogOfWarCommand(hero.Position, 5, hero.Player));
                }
                context.EventManager.Get<StrategicEvents>().CallOnStartGame();
                return CommandResult.Complete;
            }
        }
    }
}
