﻿
namespace PK.Strategic
{
    public partial class GameController
    {
        private class SwitchTurnCommand : Command
        {
            private Player _nextPlayer;

            public SwitchTurnCommand()
            {
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                _nextPlayer = context.CustomContext.NextPlayer;
                // End previous turn
                Player currentPlayer = context.CustomContext.Player;
                
                if (currentPlayer != Player.Unknown)
                {
                    context.EventManager.Get<StrategicEvents>().CallOnEndTurn(currentPlayer);
                }
                context.CustomContext.Player = _nextPlayer;

                return CommandResult.Complete;
            }

            protected override void ExecuteAfterChilds(IContext context)
            {
                // Start new turn
                context.EventManager.Get<StrategicEvents>().CallOnStartTurn(_nextPlayer);
            }
        }
    }
}
