﻿using System.Collections.Generic;
using UnityEngine;

namespace PK.Strategic
{
    public partial class GameController
    {
        private class WalkHeroCommand : Command
        {
            private ulong _id;
            private Vector2Int _target;

            public WalkHeroCommand(ulong id, Vector2Int target)
            {
                _id = id;
                _target = target;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                HexHeroModel hero = context.MapData.Map.GetHero(_id);
                List<(Vector2Int, int)> path = PathfindingHelper.FindPath(hero.Position, _target, context.MapData.ObstacleMask, context.MapData.MovementCostMask, context.MapData.Map.InteractionMask, context.MapData.Map.Size, new List<Vector2Int>() { _target });

                bool isValid = false;
                if (path != null && path.Count > 1)
                {
                    for (int i = 1; i < path.Count; i++)
                    {
                        if (path[i].Item2 <= hero.StepsLeft)
                        {
                            isValid = true;
                            break;
                        }
                    }
                }

                if (isValid)
                {
                    if (!context.MapData.IsEmpty(path[path.Count - 1].Item1))
                    {
                        path.RemoveAt(path.Count - 1);
                    }

                    PushSubCommand(new WalkHeroStartSubCommand(_id));
                    Vector2Int start = path[0].Item1;
                    int stepsLeft = hero.StepsLeft;
                    for (int i = 1; i < path.Count; i++)
                    {
                        int stepCost = path[i].Item2 - path[i - 1].Item2;
                        if (stepsLeft < stepCost)
                        {
                            break;
                        }
                        stepsLeft -= stepCost;
                        Vector2Int end = path[i].Item1;
                        PushSubCommand(new WalkHeroSubCommand(_id, start, end, stepCost));
                        start = end;
                    }
                    PushSubCommand(new WalkHeroEndSubCommand(_id));
                }
                HexContent content = context.MapData.GetContent(_target);
                if (content.Type == HexContent.ContentType.Interactable || content.Type == HexContent.ContentType.Creature)
                {
                    PushSubCommand(new TryInteractCommand(_id, content.Id));
                }

                return CommandResult.Complete;
            }
        }
    }
}
