﻿using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using UnityEngine.UIElements;
using static PK.Savefile;

namespace PK.Tactical
{
    public partial class GameController
    {
        private class ExecuteAITaskCommand : Command
        {
            private AITask _task;

            public ExecuteAITaskCommand(AITask task)
            {
                _task = task;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                if (_task is AIMoveTowardsAndAttackTask moveTowardsAndAttackTask)
                {
                    List<HexCreatureSquadModel> squads = new();
                    List<HexCreatureSquadModel> targetSquads = new();
                    SquadHelper.GetAllSquads(moveTowardsAndAttackTask.SquadId, context.MapData.Map, squads);
                    SquadHelper.GetAllSquads(moveTowardsAndAttackTask.TargetSquadId, context.MapData.Map, targetSquads);
                    
                    List<Vector2Int> selfPositions = squads.Select((s) => s.Position).ToList();
                    Dictionary<ulong, Vector2Int> targets = new();
                    Vector2Int targetPosition = context.MapData.Map.GetEntity(moveTowardsAndAttackTask.TargetSquadId).Position;
                    List<Vector2Int> ignorePositions = new(selfPositions);
                    ignorePositions.Add(targetPosition);

                    HexCreatureSquadModel firstSquad = squads[0];
                    HexCreature creature = HexDatabase.Instance.GetCreature(firstSquad.Uid);

                    List<(Vector2Int, int)> path = PathfindingHelper.FindPath(firstSquad.Position, targetPosition, context.MapData.ObstacleMask, context.MapData.MovementCostMask, context.MapData.Map.InteractionMask, context.MapData.Map.Size, ignorePositions);

                    if (path != null)
                    {
                        for (int i = 1; i < path.Count; i++)
                        {
                            if ((!context.MapData.IsEmpty(path[i].Item1) && !selfPositions.Contains(path[i].Item1)) || path[i].Item2 > creature.StepsPerTurn)
                            {
                                path.RemoveRange(i, path.Count - i);
                                break;
                            }
                        }

                        if (path.Count > 0)
                        {
                            Vector2Int target = path.Last().Item1;
                            int distance = HexHelper.AxialDistance(HexHelper.OddToAxial(firstSquad.Position), HexHelper.OddToAxial(targetPosition));
                            if (creature is HexRangedCreature hexRangedCreature && hexRangedCreature.Range >= distance)
                            {
                                if (distance == 1)
                                {
                                    PushSubCommand(new MeleeAttackSquadsCommand(squads[0].Id, moveTowardsAndAttackTask.TargetSquadId));
                                }
                                else
                                {
                                    PushSubCommand(new RangedAttackSquadsCommand(squads[0].Id, moveTowardsAndAttackTask.TargetSquadId));
                                }
                            }
                            else
                            {
                                Vector2Int axialTarget = HexHelper.OddToAxial(target);
                                targets.Add(squads[0].Id, target);

                                for (int i = 1; i < squads.Count; i++)
                                {
                                    for (int j = 0; j < 6; j++)
                                    {
                                        Vector2Int axialNext = axialTarget + HexHelper.AXIAL_DIRECTIONS[j];
                                        Vector2Int next = HexHelper.AxialToOdd(axialNext);
                                        if (!targets.Values.Contains(next) && context.MapData.IsEmpty(next))
                                        {
                                            targets.Add(squads[i].Id, next);
                                            break;
                                        }
                                    }
                                }
                                PushSubCommand(new MoveSquadsCommand(targets));
                                PushSubCommand(new MeleeAttackSquadsCommand(squads[0].Id, moveTowardsAndAttackTask.TargetSquadId));
                            }
                        }
                        else
                        {
                            PushSubCommand(new MeleeAttackSquadsCommand(squads[0].Id, moveTowardsAndAttackTask.TargetSquadId));
                        }
                    }
                }
                return CommandResult.Complete;
            }
        }
    }
}
