﻿using System.Collections.Generic;
using System.Linq;
using UnityEngine;

namespace PK.Tactical
{
    public partial class GameController
    {
        private class MoveSquadsSubCommand : Command
        {
            private List<(HexCreatureSquadModel squad, Vector2Int start, Vector2Int end)> _data;

            public MoveSquadsSubCommand(List<(HexCreatureSquadModel squad, Vector2Int start, Vector2Int end)> data)
            {
                _data = data;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                foreach ((ICreatureSquadModelForView squad, Vector2Int start, Vector2Int end) in _data)
                {
                    context.MapData.Map.MoveEntity(end, Vector2.zero, squad.Id);
                }
                context.EventManager.Get<TacticalEvents>().CallOnCreatureSquadsMove(_data.Select((d) => (d.squad as ICreatureSquadModelForView, d.start, d.end)).ToList());
                return CommandResult.Complete;
            }
        }
    }
}
