﻿
namespace PK.Tactical
{
    public partial class GameController
    {
        private class SwitchTurnCommand : Command
        {
            private Player _nextPlayer;
            private int _count;

            public SwitchTurnCommand(int count = 1)
            {
                _count = count;
            }

            protected override CommandResult ExecuteBeforeChilds(IContext context)
            {
                _nextPlayer = (Player)((int)(context.CustomContext.Player + _count) % context.CustomContext.PlayerCount);
                // End previous turn
                Player currentPlayer = context.CustomContext.Player;
                
                if (currentPlayer != Player.Unknown)
                {
                    context.EventManager.Get<TacticalEvents>().CallOnEndTurn(currentPlayer);
                }
                context.CustomContext.Player = _nextPlayer;


                // Execute global triggers
                foreach (HexGlobalTriggerModel trigger in context.MapData.Map.GlobalTriggers)
                {
                    if (trigger.Enabled)
                    {
                        // TODO player settings
                        PushSubCommand(new ExecuteActionGraphCommand(trigger.Graph, Player.Red, trigger, null));
                    }
                }

                return CommandResult.Complete;
            }

            protected override void ExecuteAfterChilds(IContext context)
            {
                // Update squads
                if (context.CustomContext.Player == Player.Red)
                {
                    foreach (HexCreatureSquadModel squad in context.MapData.Map.GetEnumerable<HexCreatureSquadModel>())
                    {
                        squad.HasAction = true;
                        squad.StepsMoved = 0;
                        if (squad.ParentSquadId == 0)
                        {
                            context.EventManager.Get<TacticalEvents>().CallOnCreatureSquadUpdate(squad.Id, true);
                        }
                    }
                }
                    
                // Start new turn
                if (context.CustomContext.BattleInProgress)
                {
                    context.EventManager.Get<TacticalEvents>().CallOnStartTurn(_nextPlayer);
                }
            }
        }
    }
}
