﻿using System.Collections.Generic;
using System.Linq;
using UnityEngine;

namespace PK.Tactical
{
    public static class SquadHelper
    {
        public static void GetAllSquads(ulong id, HexMapModel map, List<HexCreatureSquadModel> resultSquads)
        {
            HexCreatureSquadModel idSquad = map.GetEntity(id) as HexCreatureSquadModel;
            if (idSquad.ParentSquadId != 0)
            {
                id = idSquad.ParentSquadId;
            }

            foreach (HexCreatureSquadModel squad in map.GetEnumerable<HexCreatureSquadModel>(true))
            {
                // Parent squad is always first
                if (squad.Id == id)
                {
                    resultSquads.Insert(0, squad);
                }
                else if (squad.ParentSquadId == id)
                {
                    resultSquads.Add(squad);
                }
            }
        }

        public static void GetAllSquads(ulong id, HexMapModel map, List<ICreatureSquadModelForView> resultSquads)
        {
            HexCreatureSquadModel idSquad = map.GetEntity(id) as HexCreatureSquadModel;
            if (idSquad.ParentSquadId != 0)
            {
                id = idSquad.ParentSquadId;
            }

            foreach (HexCreatureSquadModel squad in map.GetEnumerable<HexCreatureSquadModel>(true))
            {
                // Parent squad is always first
                if (squad.Id == id)
                {
                    resultSquads.Insert(0, squad);
                }
                else if (squad.ParentSquadId == id)
                {
                    resultSquads.Add(squad);
                }
            }
        }

        public static bool AreSurrendering(List<HexCreatureSquadModel> squads)
        {
            HexCreature creature = HexDatabase.Instance.GetCreature(squads[0].Uid);
            int aliveSoldiers = 0;
            foreach (HexCreatureSquadModel squad in squads)
            {
                aliveSoldiers += squad.Units.Count((u) => u.Health > 0);
            }
            return (aliveSoldiers / squads.Count) < creature.MinSoldiersPerHex;
        }
    
        public static bool AreSquadsNearby(IEnumerable<Vector2Int> positions, IEnumerable<Vector2Int> targetPositions)
        {
            foreach (Vector2Int position in positions)
            {
                foreach (Vector2Int targetPosition in targetPositions)
                {
                    if (HexHelper.AxialDistance(HexHelper.OddToAxial(position), HexHelper.OddToAxial(targetPosition)) == 1)
                    {
                        return true;
                    }
                }
            }
            return false;
        }

        public static bool AreSquadsNearby(IEnumerable<HexCreatureSquadModel> squads, IEnumerable<HexCreatureSquadModel> targetSquads)
        {
            foreach (HexCreatureSquadModel squad in squads)
            {
                foreach (HexCreatureSquadModel targetSquad in targetSquads)
                {
                    if (HexHelper.AxialDistance(HexHelper.OddToAxial(squad.Position), HexHelper.OddToAxial(targetSquad.Position)) == 1)
                    {
                        return true;
                    }
                }
            }
            return false;
        }

        public static bool AreSquadsNearby(ulong id, ulong targetId, HexMapModel map)
        {
            List<HexCreatureSquadModel> squads = new();
            List<HexCreatureSquadModel> targetSquads = new();
            GetAllSquads(id, map, squads);
            GetAllSquads(targetId, map, targetSquads);
            foreach (HexCreatureSquadModel squad in squads)
            {
                foreach (HexCreatureSquadModel targetSquad in targetSquads)
                {
                    if (HexHelper.AxialDistance(HexHelper.OddToAxial(squad.Position), HexHelper.OddToAxial(targetSquad.Position)) == 1)
                    {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}
