﻿using UnityEngine;
using UnityEngine.UI;

namespace PK.Tactical
{
    public class EndTurnButton : MonoBehaviour
    {
        [SerializeField] private Button _button;

        private bool _isActive = false;

        private void Start()
        {
            OnStartTurn(TacticalGameMediator.Instance.CurrentPlayer);

            ITacticalEvents events = TacticalGameMediator.Instance.EventManager.Get<ITacticalEvents>();
            events.OnStartTurn += OnStartTurn;
            events.OnEndTurn += OnEndTurn;
        }

        private void Update()
        {
            _button.interactable = !InputLock.IsLock && _isActive;
        }

        private void OnDestroy()
        {
            ITacticalEvents events = TacticalGameMediator.Instance.EventManager.Get<ITacticalEvents>();
            events.OnStartTurn -= OnStartTurn;
            events.OnEndTurn -= OnEndTurn;
        }

        public void OnClick()
        {
            if (!InputLock.IsLock)
            {
                TacticalGameMediator.Instance.EndTurn(TacticalGameMediator.Instance.SelfPlayer);
            }
        }

        private void OnStartTurn(Player player)
        {
            _isActive = (player == TacticalGameMediator.Instance.SelfPlayer);
        }

        private void OnEndTurn(Player player)
        {
            _isActive = false;
        }
    }
}
