﻿
namespace PK.Tactical
{
    public partial class TacticalMapView : HexMapView, IEventReceiver
    {
        void IEventReceiver.AddEvents()
        {
            AddCreatureSquadsEvents();
            AddPlayerEvents();
            AddInteractionEvents();
        }

        void IEventReceiver.RemoveEvents()
        {
            RemoveCreatureSquadsEvents();
            RemovePlayerEvents();
            RemoveInteractionEvents();
        }

        protected override void OnEnable()
        {
            base.OnEnable();
            EnableCreatureSquads();
            EnablePlayerControls();
        }

        private void Update()
        {
            UpdateSelection();
            UpdateCamera();
        }
    }
}
