﻿
using UnityEngine;

namespace PK.Tactical
{
    public partial class TacticalMapView
    {
        [Space]
        [SerializeField] private Canvas _canvas;

        private IBattleMessageWindow _messageWindow;

        private void AddInteractionEvents()
        {
            ITacticalEvents events = TacticalGameMediator.Instance.EventManager.Get<ITacticalEvents>();
            events.OnStartTurn += OnStartTurn;
            events.OnEndBattle += OnEndBattle;

            IInteractionEvents interactionEvents = TacticalGameMediator.Instance.EventManager.Get<IInteractionEvents>();
            interactionEvents.OnMessage += OnMessage;
            interactionEvents.OnDialog += OnDialog;
        }

        private void RemoveInteractionEvents()
        {
            ITacticalEvents events = TacticalGameMediator.Instance.EventManager.Get<ITacticalEvents>();
            events.OnEndBattle -= OnEndBattle;
        }

        private void OnStartTurn(Player player)
        {
            _messageWindow?.Skip();
            _messageWindow = BattleMessageWindow.Create(_canvas.transform, player == TacticalGameMediator.Instance.SelfPlayer ? BattleMessageWindow.Message.PlayerTurn : BattleMessageWindow.Message.EnemyTurn, 0.5f);
        }

        private void OnEndBattle(Player player)
        {
            _messageWindow?.Skip();
            _messageWindow = BattleMessageWindow.Create(_canvas.transform, player == TacticalGameMediator.Instance.SelfPlayer ? BattleMessageWindow.Message.Victory : BattleMessageWindow.Message.Defeat);
        }

        private void OnMessage(IDialogMessageForView messageForView, Player player)
        {
            if (player != TacticalGameMediator.Instance.SelfPlayer)
            {
                return;
            }

            DialogWindow.Create(GameClient.Instance.Canvas.transform, messageForView, null, (int index) =>
            {
                messageForView.Skip();
            });
        }

        private void OnDialog(IDialogChoicesForView dialogChoicesForView, Player player)
        {
            if (player != TacticalGameMediator.Instance.SelfPlayer)
            {
                return;
            }

            DialogWindow.Create(GameClient.Instance.Canvas.transform, dialogChoicesForView, dialogChoicesForView, (int index) =>
            {
                dialogChoicesForView.SelectChoice(index);
            });
        }
    }
}
