﻿using System;
using UnityEngine;

namespace PK
{
    public class TryAgainWindow : MonoBehaviour
    {
		private Action<bool> _callback;

		public static TryAgainWindow Create(Transform parent, Action<bool> callback)
		{
			GameObject prefab = Resources.Load("Windows/TryAgainWindow") as GameObject;
			GameObject gameObject = Instantiate(prefab, parent.transform);
			TryAgainWindow window = gameObject.GetComponent<TryAgainWindow>();
			window.Initialize(callback);
			return window;
		}

		private void Initialize(Action<bool> callback)
        {
			_callback = callback;
		}

		public void OnYesClick()
		{
			_callback?.Invoke(true);
			Destroy(gameObject);
		}

		public void OnNoClick()
		{
			_callback?.Invoke(false);
			Destroy(gameObject);
		}
	}
}
