﻿using UnityEngine;
using UnityEngine.InputSystem;
using UnityEngine.InputSystem.Interactions;

namespace PK
{
    public class ControlHandler : MonoBehaviour
    {
        private static ControlHandler _instance;

        public static ControlHandler Instance => _instance;

        private InputControls _controls;
        private int _leftTapFrame;
        private int _leftHoldStartFrame;
        private int _leftHoldEndFrame;
        private int _rightTapFrame;

        public bool WasLeftPressed { get { return _controls.General.LeftClick.WasPressedThisFrame(); } }
        public bool IsLeftPressed { get { return _controls.General.LeftClick.IsPressed(); } }
        public bool WasLeftClicked { get { return _leftTapFrame == Time.frameCount; } }
        public bool WasRightClicked { get { return _rightTapFrame == Time.frameCount; } }
        public bool IsStartingDragging { get { return _leftHoldStartFrame == Time.frameCount; } }
        public bool IsEndingDragging { get { return _leftHoldEndFrame == Time.frameCount; } }

        private void Awake()
        {
            if (_instance != null)
            {
                Destroy(_instance.gameObject);
            }
            _instance = this;
            _controls = new InputControls();
        }

        private void OnEnable()
        {
            _controls.Enable();
            _controls.General.LeftClick.performed += OnLeftClickPerformed;
            _controls.General.LeftClick.canceled += OnLeftClickCanceled;
            _controls.General.RightClick.performed += OnRightClickPerformed;
        }

        private void OnDisable()
        {
            _controls.Disable();
            _controls.General.LeftClick.performed -= OnLeftClickPerformed;
            _controls.General.LeftClick.canceled -= OnLeftClickCanceled;
            _controls.General.RightClick.performed -= OnRightClickPerformed;
        }

        private void OnLeftClickPerformed(InputAction.CallbackContext context)
        {
            if (context.interaction is TapInteraction)
            {
                _leftTapFrame = Time.frameCount;
            }
            if (context.interaction is HoldInteraction)
            {
                _leftHoldStartFrame = Time.frameCount;
            }
        }

        private void OnLeftClickCanceled(InputAction.CallbackContext context)
        {
            if (context.interaction is HoldInteraction)
            {
                _leftHoldEndFrame = Time.frameCount;
            }
        }

        private void OnRightClickPerformed(InputAction.CallbackContext context)
        {
            if (context.interaction is TapInteraction)
            {
                _rightTapFrame = Time.frameCount;
            }
        }
    }
}
