﻿using UnityEngine;

namespace PK
{
    public class ActionFadeScreenNode : ActionDefaultNode, IFlowNode
    {
        private enum Mode
        {
            FadeIn,
            FadeOut
        }

        private static string LOCK = "ActionFadeScreenNodeLock";

        [SerializeField] private Mode _mode;
        [SerializeField] private bool _hideUI = true;
        [SerializeField] private float _time = 1;

        public void Execute(IActionContext context)
        {
            if (_mode == Mode.FadeIn)
            {
                context.Locker.Lock(LOCK);
                FadeView.Instance.FadeIn(_time, 0, _hideUI, () =>
                {
                    context.Locker.Unlock(LOCK);
                    context.Graph.MoveToNextNode(_outPortGuid);
                });
            }
            else
            {
                context.Locker.Lock(LOCK);
                FadeView.Instance.FadeOut(_time, 0, _hideUI, () =>
                {
                    context.Locker.Unlock(LOCK);
                    context.Graph.MoveToNextNode(_outPortGuid);
                });
            }
        }
    }
}
