using UnityEngine;

namespace PK
{
    [System.Serializable]
    public class ActionGraph : BaseGraph
    {
        [SerializeField] private string _currentNodeGuid;

        public string CurrentNodeGuid { get { return _currentNodeGuid; } set { _currentNodeGuid = value; } }

        public void MoveToNextNode(string portGuid)
        {
            string nodeGuid = GetConnectedNodeGuid(portGuid);
            if (!string.IsNullOrEmpty(nodeGuid))
            {
                _currentNodeGuid = nodeGuid;
            }
        }
    }
}