﻿using UnityEngine;

namespace PK
{
    public class ActionModifyVariableNode : ActionDefaultNode, IFlowNode
    {
        private enum OperationType
        {
            Set,
            Add,
            Subtract
        }

        [SerializeField] private ulong _id;
        [SerializeField] private string _name;
        [SerializeField] private VariableType _type;
        [SerializeField] private OperationType _operation;
        [SerializeField] private bool _boolValue;
        [SerializeField] private int _intValue;

        public ulong Id { get { return _id; } set { _id = value; } }
        public string Name { get { return _name; } set { _name = value; } }
        public VariableType Type { get { return _type; } set { _type = value; } }

        void IFlowNode.Execute(IActionContext context)
        {
            VariableType variableType = context.Map.GlobalVariables.GetVariableType(_id);
            if (_type != variableType) {
                Debug.LogError($"ActionModifyVariableNode: variable type mismatch!");
            }
            else if (_type == VariableType.Bool)
            {
                context.Map.GlobalVariables.SetBool(_id, _boolValue);
                context.EventManager.Get<MapEvents>().CallOnBoolVariableChange(_name, _boolValue);
            }
            else
            {
                int value = _intValue;
                int variableValue = context.Map.GlobalVariables.GetInt(_id);
                switch (_operation)
                {
                    case OperationType.Set:
                        variableValue = value;
                        break;
                    case OperationType.Add:
                        variableValue += value;
                        break;
                    case OperationType.Subtract:
                        variableValue -= value;
                        break;
                }
                context.Map.GlobalVariables.SetInt(_id, variableValue);
                context.EventManager.Get<MapEvents>().CallOnIntVariableChange(_name, variableValue);
            }
            context.Graph.MoveToNextNode(_outPortGuid);
        }
    }
}
