﻿using DG.Tweening;
using UnityEngine;

namespace PK
{
    public class ActionPlaySfxNode : ActionDefaultNode, IFlowNode
    {
        private static string LOCK = "ActionPlaySfxNodeLock";

        [SerializeField] private AudioPreset _sfx;
        [SerializeField] private bool _waitForEnd = false;

        public void Execute(IActionContext context)
        {
            if (_waitForEnd)
            {
                context.Locker.Lock(LOCK);
                AudioHandler.Instance.PlaySfx(_sfx, () =>
                {
                    context.Locker.Unlock(LOCK);
                    context.Graph.MoveToNextNode(_outPortGuid);
                });
            }
            else
            {
                AudioHandler.Instance.PlaySfx(_sfx);
                context.Graph.MoveToNextNode(_outPortGuid);
            }
        }
    }
}
