﻿using DG.Tweening;
using UnityEngine;

namespace PK
{
    public class ActionWaitNode : ActionDefaultNode, IFlowNode
    {
        private static string LOCK = "ActionWaitNodeLock";

        [SerializeField] private float _time;

        public void Execute(IActionContext context)
        {
            context.Locker.Lock(LOCK);
            DOVirtual.DelayedCall(_time, () =>
            {
                context.Locker.Unlock(LOCK);
                context.Graph.MoveToNextNode(_outPortGuid);
            });
        }
    }
}
