using UnityEditor;
using UnityEditor.UIElements;
using UnityEngine;
using UnityEngine.UIElements;

namespace PK
{
    [CustomPropertyDrawer(typeof(ActionGraph))]
    public class ActionGraphPropertyDrawer : PropertyDrawer
    {
        private SerializedProperty _property;

        public override VisualElement CreatePropertyGUI(SerializedProperty property)
        {
            _property = property;

            VisualElement container = new VisualElement();

            PropertyField propertyField = new PropertyField(property);
            Button button = new Button(OnButtonClicked) { text = "Edit" };

            container.Add(propertyField);
            container.Add(button);

            return container;
        }

        public override void OnGUI(Rect position, SerializedProperty property, GUIContent label)
        {
            _property = property;
            position.height = EditorGUI.GetPropertyHeight(property, true);
            EditorGUI.PropertyField(position, property, true);
            position.y += position.height + EditorGUIUtility.standardVerticalSpacing;
            position.height = EditorGUIUtility.singleLineHeight;
            if (GUI.Button(position, "Edit"))
            {
                OnButtonClicked();
            }
        }

        public override float GetPropertyHeight(SerializedProperty property, GUIContent label)
        {
            return EditorGUI.GetPropertyHeight(property, true) + EditorGUIUtility.standardVerticalSpacing + EditorGUIUtility.singleLineHeight;
        }

        private void OnButtonClicked()
        {
            ActionGraphEditorWindow.Open(_property.serializedObject.targetObject, _property.propertyPath);
        }
    }
}
