﻿using UnityEditor;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionCheckCharacterNode), "Entities/Check Character")]
    public class ActionCheckCharacterEditorNode : ActionDefaultEditorNode
    {
        public ActionCheckCharacterEditorNode(SerializedProperty property) : base(property)
        {
            title = "Check Character";
            SetTitleColor(Styles.CheckGameStateTitleColor);
            InitializeDefaultPorts(false, true, null, typeof(ConditionPort));

            SerializedProperty valueProperty = property.FindPropertyRelative("_value");
            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                PropertyHelper.PropertyField(valueProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
