﻿using UnityEditor;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionModifyEntityEnabledNode), "Entities/Modify Enabled")]
    public class ActionModifyEntityEnabledEditorNode : ActionDefaultEditorNode
    {
        public ActionModifyEntityEnabledEditorNode(SerializedProperty property) : base(property)
        {
            title = "Modify Entity Enabled";
            SetTitleColor(Styles.ChangeGameStateTitleColor);
            InitializeDefaultPorts(true, true);

            SerializedProperty isSelfProperty = property.FindPropertyRelative("_isSelf");
            SerializedProperty entityIdProperty = property.FindPropertyRelative("_entityId");
            SerializedProperty valueProperty = property.FindPropertyRelative("_value");

            EntityButton entityButton = new EntityButton(this, entityIdProperty);
            entityButton.Update(!isSelfProperty.boolValue);
            extensionContainer.Add(entityButton);

            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                PropertyHelper.PropertyField(isSelfProperty);
                PropertyHelper.PropertyField(valueProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    entityButton.Update(!isSelfProperty.boolValue);
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
