﻿using UnityEditor;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionPlayAmbienceNode), "Audio/Play Ambience")]
    public class ActionPlayAmbienceEditorNode : ActionDefaultEditorNode
    {
        public ActionPlayAmbienceEditorNode(SerializedProperty property) : base(property)
        {
            title = "Play Ambience";
            SetTitleColor(Styles.ChangeGameStateTitleColor);
            InitializeDefaultPorts(true, true);

            SerializedProperty ambienceProperty = property.FindPropertyRelative("_ambience");
            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                PropertyHelper.PropertyField(ambienceProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
