﻿using UnityEditor;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionPlaySfxNode), "Audio/Play Sfx")]
    public class ActionPlaySfxEditorNode : ActionDefaultEditorNode
    {
        public ActionPlaySfxEditorNode(SerializedProperty property) : base(property)
        {
            title = "Play Sfx";
            SetTitleColor(Styles.ChangeGameStateTitleColor);
            InitializeDefaultPorts(true, true);

            SerializedProperty sfxProperty = property.FindPropertyRelative("_sfx");
            SerializedProperty waitForEndProperty = property.FindPropertyRelative("_waitForEnd");
            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                PropertyHelper.PropertyField(sfxProperty);
                PropertyHelper.PropertyField(waitForEndProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
