﻿using UnityEditor;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionPushAmbienceNode), "Audio/Push Ambience")]
    public class ActionPushAmbienceEditorNode : ActionDefaultEditorNode
    {
        public ActionPushAmbienceEditorNode(SerializedProperty property) : base(property)
        {
            title = "Push Ambience";
            SetTitleColor(Styles.ChangeGameStateTitleColor);
            InitializeDefaultPorts(true, true);

            SerializedProperty ambienceProperty = property.FindPropertyRelative("_ambience");
            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                PropertyHelper.PropertyField(ambienceProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
