﻿using UnityEditor;
using UnityEditor.Experimental.GraphView;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(ActionStartBattleNode), "Start Battle")]
    public class ActionStartBattleEditorNode : ActionDefaultEditorNode
    {
        public ActionStartBattleEditorNode(SerializedProperty property) : base(property)
        {
            title = "Start Battle";
            SetTitleColor(Styles.ChangeGameStateTitleColor);

            SerializedProperty inPortGuidProperty = property.FindPropertyRelative("_inPortGuid");
            SerializedProperty outPortAGuidProperty = property.FindPropertyRelative("_outPortAGuid");
            SerializedProperty outPortBGuidProperty = property.FindPropertyRelative("_outPortBGuid");

            Port inPort = InstantiatePort(Orientation.Horizontal, Direction.Input, Port.Capacity.Multi, "In", typeof(FlowPort));
            inputContainer.Add(inPort);

            if (string.IsNullOrEmpty(inPortGuidProperty.stringValue))
            {
                inPortGuidProperty.stringValue = inPort.viewDataKey;
            }
            else
            {
                inPort.viewDataKey = inPortGuidProperty.stringValue;
            }
            AddPort(inPort);

            Port outAPort = InstantiatePort(Orientation.Horizontal, Direction.Output, Port.Capacity.Single, "Out Win", typeof(FlowPort));
            outputContainer.Add(outAPort);

            if (string.IsNullOrEmpty(outPortAGuidProperty.stringValue))
            {
                outPortAGuidProperty.stringValue = outAPort.viewDataKey;
            }
            else
            {
                outAPort.viewDataKey = outPortAGuidProperty.stringValue;
            }
            AddPort(outAPort);

            Port outBPort = InstantiatePort(Orientation.Horizontal, Direction.Output, Port.Capacity.Single, "Out Lose", typeof(FlowPort));
            outputContainer.Add(outBPort);

            if (string.IsNullOrEmpty(outPortBGuidProperty.stringValue))
            {
                outPortBGuidProperty.stringValue = outBPort.viewDataKey;
            }
            else
            {
                outBPort.viewDataKey = outPortBGuidProperty.stringValue;
            }
            AddPort(outBPort);

            SerializedProperty mapProperty = property.FindPropertyRelative("_map");
            SerializedProperty enemiesProperty = property.FindPropertyRelative("_enemies");
            SerializedProperty canRetryProperty = property.FindPropertyRelative("_canRetry");
            SerializedProperty enemyStartsProperty = property.FindPropertyRelative("_enemyStarts");
            SerializedProperty specificFightingHeroProperty = property.FindPropertyRelative("_specificHero");
            SerializedProperty heroEntityIdProperty = property.FindPropertyRelative("_heroEntityId");

            EntityButton heroEntityButton = new EntityButton(this, heroEntityIdProperty);
            heroEntityButton.Update(specificFightingHeroProperty.boolValue);
            extensionContainer.Add(heroEntityButton);

            IMGUIContainer propertiesField = new IMGUIContainer(() =>
            {
                EditorGUI.BeginChangeCheck();
                EditorGUILayout.PropertyField(mapProperty);
                EditorGUILayout.PropertyField(enemiesProperty);
                EditorGUILayout.PropertyField(canRetryProperty);
                EditorGUILayout.PropertyField(enemyStartsProperty);
                EditorGUILayout.PropertyField(specificFightingHeroProperty);
                if (EditorGUI.EndChangeCheck())
                {
                    heroEntityButton.Update(specificFightingHeroProperty.boolValue);
                    _property.serializedObject.ApplyModifiedProperties();
                }
            });
            extensionContainer.Add(propertiesField);

            Refresh();
        }
    }
}
