﻿using System.Collections.Generic;
using UnityEngine;
using PK.Tactical;

namespace PK
{
    public class ActionCreatureSquadsSurrenderNode : ActionDefaultNode, IFlowNode
    {
        [SerializeField] private Player _player = Player.Unknown;
        [SerializeField] private List<HexCreature> _creatures;

        public void Execute(IActionContext context)
        {
            List<(ICreatureSquadModelForView, Vector2Int)> surrenderData = new();
            foreach (HexCreatureSquadModel squad in context.Map.GetEnumerable<HexCreatureSquadModel>(true))
            {
                if (_player != Player.Unknown && squad.Player != _player)
                {
                    continue;
                }
                HexCreature creature = HexDatabase.Instance.GetCreature(squad.Uid);
                if (_creatures.Contains(creature))
                {
                    // TODO: get rid of duplicate code from DamageSquadsCommand
                    squad.Enabled = false;
                    Vector2Int leftTarget = squad.Position;
                    Vector2Int rightTarget = squad.Position;
                    while (context.Map.GetTerrainTile(leftTarget.x, leftTarget.y) != 0)
                    {
                        leftTarget += Vector2Int.left;
                    }
                    while (context.Map.GetTerrainTile(rightTarget.x, rightTarget.y) != 0)
                    {
                        rightTarget += Vector2Int.right;
                    }
                    surrenderData.Add((squad, Vector2Int.Distance(leftTarget, squad.Position) < Vector2Int.Distance(rightTarget, squad.Position) ? (leftTarget + Vector2Int.right) : (rightTarget + Vector2Int.left)));
                }
            }
            context.EventManager.Get<TacticalEvents>().CallOnCreatureSquadsSurrender(surrenderData);
            context.Graph.MoveToNextNode(_outPortGuid);
        }
    }
}
