﻿using System.Collections.Generic;
using UnityEngine;

namespace PK
{
    [UnityEngine.Scripting.APIUpdating.MovedFrom(false, null, null, "HexSpawnPointModel")]
    public class HexSpawnAreaModel : HexEntityModel
    {
        [SerializeField] private Player _player;
        [SerializeField, HideInInspector] private List<Vector2Int> _points = new(); // axial

        public override EntityType Type { get { return EntityType.SpawnPoint; } }
        public Player Player { get { return _player; } }
        public List<Vector2Int> Points { get { return _points; } }

        public HexSpawnAreaModel()
        {
        }

        public HexSpawnAreaModel(ulong id, Vector2Int position)
        {
            _id = id;
            _position = position;
        }

        public Vector2Int GetPosition(int index)
        {
            return HexHelper.AxialToOdd(HexHelper.OddToAxial(_position) + _points[index]);
        }
    }
}
