﻿using UnityEngine;

namespace PK
{
    public class CapturableBuildingInteraction : BaseInteraction
    {
        [System.Serializable]
        public class ResourceGenerationData
        {
            [SerializeField] private string _name;
            [SerializeField] private int _amount;

            public string Name { get { return _name; } }
            public int Amount { get { return _amount; } }
        }

        [SerializeField] private Player _player = Player.Unknown;
        [SerializeField] private ResourceGenerationData[] _resourcesGeneration;

        public Player Player { get { return _player; } set { _player = value; } }
        public ResourceGenerationData[] ResourcesGeneration { get { return _resourcesGeneration; } }
    }
}
