﻿using UnityEditor;
using UnityEditor.Experimental.GraphView;
using UnityEngine;
using UnityEngine.UIElements;

namespace PK
{
    [EditorNode(typeof(StickyNoteNode), "Sticky Note")]
    public class StickyNoteEditorNode : BaseGraphEditorNode
    {
        public StickyNoteEditorNode(SerializedProperty property) : base(property)
        {
            title = "Sticky Note";
            SerializedProperty textProperty = property.FindPropertyRelative("_text");
            TextField textField = new TextField();
            textField.value = textProperty.stringValue;
            textField.multiline = true;
            textField.RegisterCallback((ChangeEvent<string> evt) =>
            {
                textProperty.stringValue = evt.newValue;
                textProperty.serializedObject.ApplyModifiedProperties();
            });
            textField.style.maxWidth = 150f;
            textField.style.minHeight = 50f;
            textField.style.whiteSpace = WhiteSpace.Normal;
            textField.style.unityTextAlign = TextAnchor.UpperLeft;
            inputContainer.RemoveFromHierarchy();
            outputContainer.RemoveFromHierarchy();
            mainContainer.Add(textField);
        }
    }
}
