﻿using System.Collections;
using UnityEngine;
using UnityEngine.UI;

namespace PK
{
    public class AnimatedImage : MonoBehaviour
    {
        [SerializeField] private Image _image;

        private Sprite[] _sprites;
        private float _framesPerSecond;
        private Coroutine _switchCoroutine;

        private void Awake()
        {
            _image.enabled = false;
        }

        public void Initialize(Sprite[] sprites, float framesPerSecond)
        {
            _sprites = sprites;
            _framesPerSecond = framesPerSecond;
            if (_sprites != null && _sprites.Length > 0)
            {
                _image.enabled = true;
                if (_sprites.Length > 1)
                {
                    if (_switchCoroutine != null)
                    {
                        StopCoroutine(_switchCoroutine);
                    }
                    StartCoroutine(SwitchCoroutine());
                }
                else
                {
                    _image.sprite = sprites[0];
                }
            }
            else
            {
                _image.enabled = false;
            }
        }

        private IEnumerator SwitchCoroutine()
        {
            int index = 0;
            while (true)
            {
                _image.sprite = _sprites[index];
                index = (index + 1) % _sprites.Length;
                yield return new WaitForSeconds(1.0f / _framesPerSecond);
            }
        }
    }
}
