﻿using UnityEngine;
using UnityEngine.Events;
using UnityEngine.EventSystems;
using UnityEngine.UI;

namespace PK
{
    public class ButtonExt : Button
    {
        [SerializeField] ButtonHoveredEvent _onHoverBegin = new();
        [SerializeField] ButtonHoveredEvent _onHoverEnd = new();

        public ButtonHoveredEvent onHoverBegin { get { return _onHoverBegin; } set { _onHoverBegin = value; } }
        public ButtonHoveredEvent onHoverEnd { get { return _onHoverEnd; } set { _onHoverEnd = value; } }

        public override void OnPointerEnter(PointerEventData eventData)
        {
            base.OnPointerEnter(eventData);
            onHoverBegin?.Invoke();
        }

        public override void OnPointerExit(PointerEventData eventData)
        {
            base.OnPointerExit(eventData);
            onHoverEnd?.Invoke();
        }

        public class ButtonHoveredEvent : UnityEvent
        {
            public ButtonHoveredEvent()
            {
            }
        }
    }
}
