﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    [CustomPropertyDrawer(typeof(HexShadowGroups.ShadowGroup))]
    public class ShadowGroupPropertyDrawer : PropertyDrawer
    {
        public override void OnGUI(Rect position, SerializedProperty property, GUIContent label)
        {
            bool foldout = property.isExpanded;

            // Foldout
            position.height = EditorGUIUtility.singleLineHeight;
            foldout = EditorGUI.Foldout(position, foldout, label);
            property.isExpanded = foldout;
            position.y += position.height + EditorGUIUtility.standardVerticalSpacing;

            // Indent
            position.x += EditorGUIUtility.singleLineHeight;
            position.width -= EditorGUIUtility.singleLineHeight;

            if (foldout)
            {
                SerializedProperty nameProperty = property.FindPropertyRelative("_name");
                SerializedProperty castShadowProperty = property.FindPropertyRelative("_castShadow");
                SerializedProperty receiveShadowMaskProperty = property.FindPropertyRelative("_receiveShadowMask");

                EditorGUILayout.PropertyField(nameProperty);
                EditorGUILayout.PropertyField(castShadowProperty);
                ShadowGroupHelper.DrawMaskProperty(receiveShadowMaskProperty);
            }
        }
    }
}
