﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    public abstract class GenericPlacingTool<T> : MapEditorTool where T : Object
    {
        protected T _brushSelectedInstance;
        protected Vector2Int _hoveredTile;

        protected abstract T[] Data { get; }

        protected abstract Texture2D GetIcon(T instance);
        protected abstract void Place();

        public override void OnInspectorPanel()
        {
            T[] data = Data;
            int i = 0;
            bool clickedAny = false;
            while (i < data.Length)
            {
                GUILayout.BeginHorizontal();
                for (int j = 0, n = (int)(EditorGUIUtility.currentViewWidth / (BUTTON_SIZE.x + 5)); j < n && i < data.Length; j++)
                {
                    T instance = data[i];
                    bool isSelected = _brushSelectedInstance == instance;
                    if (isSelected)
                    {
                        EditorGUI.BeginDisabledGroup(true);
                    }
                    if (GUILayout.Button(new GUIContent(GetIcon(instance), instance.name), GUILayout.Width(BUTTON_SIZE.x), GUILayout.Height(BUTTON_SIZE.y)))
                    {
                        _brushSelectedInstance = instance;
                        clickedAny = true;
                    }
                    if (isSelected)
                    {
                        EditorGUI.EndDisabledGroup();
                    }
                    ++i;
                }
                GUILayout.EndHorizontal();
            }

            if (!clickedAny && Event.current.type == EventType.MouseDown)
            {
                _brushSelectedInstance = null;
                _editor.Repaint();
            }
        }

        public override void OnMouseMove()
        {
            _hoveredTile = _view.GetHexPosition(GetMouseWorldPosition());
        }

        public override void OnMouseClick()
        {
            if (Event.current.button != 0)
            {
                return;
            }

            if (_brushSelectedInstance != null)
            {
                Place();
            }
            Event.current.Use();
        }
    }
}
