﻿using UnityEditor;
using UnityEngine;

namespace PK
{
    public class PaintRoadsTool : MapEditorTool
    {
        private Vector2Int _hoveredTile;
        private byte _currentType = 1;
        private byte _index = 0;


        public override void OnInspectorPanel()
        {
            GUILayout.Label("Select road:", EditorStyles.boldLabel);
            foreach (HexRoad road in HexDatabase.Instance.Roads)
            {
                GUI.enabled = road.Type != _currentType;
                if (GUILayout.Button(road.name))
                {
                    _currentType = road.Type;
                }
                GUI.enabled = true;
            }
            _index = (byte)EditorGUILayout.IntSlider("Index", _index, 0, 5);
        }

        public override void OnMouseMove()
        {
            _hoveredTile = _view.GetHexPosition(GetMouseWorldPosition());
        }

        public override void OnMouseDown()
        {
            if (Event.current.button == 0)
            {
                RecordUndo();
                _view.PlaceRoad(_hoveredTile, _currentType, _index);
                Event.current.Use();
            }
        }

        public override void OnDrawHandle()
        {
            DrawTileHandle(_hoveredTile);
        }
    }
}
