﻿using UnityEngine;

namespace PK
{
    public class PlaceCreaturesTool : GenericPlacingTool<HexCreature>
    {
        protected override HexCreature[] Data => HexDatabase.Instance.Creatures;

        protected override Texture2D GetIcon(HexCreature instance)
        {
            return _editor.GetIcon(instance.AnySprite);
        }

        protected override void Place()
        {
            if (_view.CanPlaceCreature(_hoveredTile))
            {
                RecordUndo();
                _view.PlaceCreature(_hoveredTile, _brushSelectedInstance);
            }
        }

        public override void OnDrawHandle()
        {
            if (_brushSelectedInstance != null)
            {
                DrawTileHandle(_hoveredTile);
                Vector3 position = GetMouseWorldPosition();
                DrawSpriteHandle(_brushSelectedInstance.AnySprite, HexHelper.GetTilePosition(HexHelper.GetHexPosition(position)));
            }
        }
    }
}
