﻿using System.Collections.Generic;
using UnityEditor;
using UnityEngine;

namespace PK
{
    public class RemoveTerrainTool : MapPaintingTool
    {
        private static string REMOVE_TERRAIN_BRUSH_SIZE = "RemoveTerrainBrushSize";
        private static string REMOVE_TERRAIN_BRUSH_DENSITY = "RemoveTerrainBrushDensity";

        protected override int BrushSize
        {
            get
            {
                return EditorPrefs.GetInt(REMOVE_TERRAIN_BRUSH_SIZE);
            }
            set
            {
                EditorPrefs.SetInt(REMOVE_TERRAIN_BRUSH_SIZE, value);
            }
        }

        protected override int BrushDensity
        {
            get
            {
                return EditorPrefs.GetInt(REMOVE_TERRAIN_BRUSH_DENSITY);
            }
            set
            {
                EditorPrefs.SetInt(REMOVE_TERRAIN_BRUSH_DENSITY, value);
            }
        }

        protected override Color PaintingToolGridColor => Color.red;

        public override bool IsToolReady()
        {
            return true;
        }

        public override void OnInspectorPanel()
        {
            EditorGUI.BeginChangeCheck();

            PaintingToolInspectorPanel();

            if (EditorGUI.EndChangeCheck())
            {
                SceneView.RepaintAll();
            }
        }

        public override void OnMouseDown()
        {
            if (Event.current.button == 0)
            {
                RecordUndo();
                _view.PauseEditorUpdates();
                List<Vector2Int> neighbours = GetPaintedHexes();
                foreach (Vector2Int neighbour in neighbours)
                {
                    _view.RemoveTile(neighbour);
                }
                _view.ResumeEditorUpdates();
                Event.current.Use();
            }
        }
    }
}
