﻿using UnityEngine;

namespace PK
{
    public static class HexEntityViewFactory
    {
        public static HexEntityView Create(Transform parent, IEntityModelForView modelForView, bool isStrategic)
        {
            HexEntityView view = null;
            switch (modelForView.Type)
            {
                case EntityType.Object:
                    HexObject prop = HexDatabase.Instance.GetObject(modelForView.Uid);
                    if (prop == null)
                    {
                        Debug.LogError($"Prop {modelForView.Uid} is missing.");
                        return null;
                    }
                    GameObject child = new();
                    child.transform.SetParent(parent, false);
                    view = child.AddComponent<HexObjectView>();
                    break;
                case EntityType.Creature:
                    HexCreature creature = HexDatabase.Instance.GetCreature(modelForView.Uid);
                    if (creature == null)
                    {
                        Debug.LogError($"Creature {modelForView.Uid} is missing.");
                        return null;
                    }
                    view = creature.GetView(parent, true);
                    break;
                case EntityType.CreatureSquad:
                    HexCreature creatureSquad = HexDatabase.Instance.GetCreature(modelForView.Uid);
                    if (creatureSquad == null)
                    {
                        Debug.LogError($"Creature squad {modelForView.Uid} is missing.");
                        return null;
                    }
                    HexCreatureSquadView squadView = creatureSquad.GetView(parent, false) as HexCreatureSquadView;
                    squadView.UnitViewPrefab = creatureSquad.TacticalMapUnitPrefab;
                    view = squadView;
                    break;
                case EntityType.Hero:
                    HexHero hero = HexDatabase.Instance.GetHero(modelForView.Uid);
                    if (hero == null)
                    {
                        Debug.LogError($"Hero {modelForView.Uid} is missing.");
                        return null;
                    }
                    view = hero.GetView(parent, isStrategic);
                    break;
                case EntityType.ProximityTrigger:
                case EntityType.SpawnPoint:
                case EntityType.MapZone:
                    child = new();
                    child.transform.SetParent(parent, false);
                    view = child.AddComponent<HexTechicalView>();
                    break;
            }
            if (view == null)
            {
                Debug.LogError("Can't create view.");
                return null;
            }
            view.Initialize(modelForView);

            if (!Application.isPlaying)
            {
                view.gameObject.hideFlags = HideFlags.HideAndDontSave;
            }

            return view;
        }
    }
}
