﻿Shader "Unlit/HexCreature"
{
    Properties
    {
        _MainTex("Texture", 2D) = "white" {}
        _OutlineColor("OutlineColor", Color) = (1, 1, 1, 1)
        _OutlineThickness("OutlineThickness", Range(1.0, 3.0)) = 1.0
    }
    SubShader
    {
        Blend SrcAlpha OneMinusSrcAlpha, One OneMinusSrcAlpha
        Cull Off
        ZWrite Off

        Tags { "Queue" = "Transparent" }

        Pass
        {
            Tags { "LightMode" = "Universal2D" }

            HLSLPROGRAM
            #include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"

            #pragma vertex DefaultVertex
            #pragma fragment DefaultFragment

            #pragma shader_feature_local_fragment _ _OUTLINE

            struct Attributes
            {
                float3 positionOS   : POSITION;
                float2 uv           : TEXCOORD0;
            };

            struct Varyings
            {
                float4 positionCS   : SV_POSITION;
                float2 uv           : TEXCOORD0;
            };

            TEXTURE2D(_MainTex);
            SAMPLER(sampler_MainTex);
            float4 _MainTex_ST;
            float4 _MainTex_TexelSize;

            float4 _OutlineColor;
            float _OutlineThickness;

            Varyings DefaultVertex(Attributes v)
            {
                Varyings o = (Varyings)0;
                o.positionCS = TransformObjectToHClip(v.positionOS);
                o.uv = TRANSFORM_TEX(v.uv, _MainTex);
                return o;
            }

            half4 DefaultFragment(Varyings i) : SV_Target
            {
                half4 main = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv);

#if defined(_OUTLINE)
                float2 offset = _MainTex_TexelSize.xy * _OutlineThickness;
                float4 sample1 = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv + float2(offset.x, 0));
                float4 sample2 = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv - float2(offset.x, 0));
                float4 sample3 = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv + float2(0, offset.y));
                float4 sample4 = SAMPLE_TEXTURE2D(_MainTex, sampler_MainTex, i.uv - float2(0, offset.y));

                if (main.a < 0.1f && (sample1.a > 0.1f || sample2.a > 0.1f || sample3.a > 0.1f || sample4.a > 0.1f))
                {
                    return _OutlineColor;
                }
#endif
                return main;
            }
            ENDHLSL
        }

        Pass
        {
            Name "SceneSelectionPass"
            Tags { "LightMode" = "SceneSelectionPass" }

            HLSLPROGRAM
            #include "Packages/com.unity.render-pipelines.universal/ShaderLibrary/Core.hlsl"

            #pragma vertex EditorPassVertex
            #pragma fragment EditorPassDepthFragment

            struct Attributes
            {
                float3 positionOS	: POSITION;
            };

            struct Varyings
            {
                float4 positionCS	: SV_POSITION;
            };

            Varyings EditorPassVertex(Attributes v)
            {
                Varyings o = (Varyings)0;
                o.positionCS = TransformObjectToHClip(v.positionOS);
                return o;
            }

            void EditorPassDepthFragment(Varyings i)
            {
            }

            ENDHLSL
            }
    }
}
