using UnityEditor;
using UnityEditor.AssetImporters;
using UnityEngine;

namespace PK
{
    [CustomEditor(typeof(HexMapImporter))]
    public class HexMapImporterEditor : ScriptedImporterEditor
    {
        public override void OnInspectorGUI()
        {
            if (GUILayout.Button("Convert"))
            {
                HexMap map = (HexMap)assetTarget;
                string path = AssetDatabase.GetAssetPath(map);
                AssetDatabase.CreateAsset(Instantiate(map), path.Replace(".hexmap", ".asset"));
            }
            ApplyRevertGUI();
        }
    }
}
