using System.IO;
using UnityEditor;
using UnityEditor.AssetImporters;
using UnityEngine;

namespace PK
{
    [ScriptedImporter(1, ".hexmap")]
    public class HexMapImporter : ScriptedImporter
    {
        public override void OnImportAsset(AssetImportContext ctx)
        {
            try
            {
                HexMapModel model = new HexMapModel();
                string content = File.ReadAllText(ctx.assetPath);
                JsonUtility.FromJsonOverwrite(content, model);
                EditorUtility.SetDirty(this);
                HexMap map = ScriptableObject.CreateInstance<HexMap>();
                map.Initialize(model);

                ctx.AddObjectToAsset("Map", map);
                ctx.SetMainObject(map);
            }
            catch (System.Exception e)
            {
                Debug.LogError(e.Message);
            }
        }
    }
}
